﻿<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Kasa.UI" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="System.Collections.Generic" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Zaległości kontrahentów</title>
	<script runat="server">
        struct Zaleglosc
        {
            public string Waluta { get; set; }
            public IPodmiotKasowy Podmiot { get; set; }
            public Currency DoRozliczenia { get; set; }
        }

        Dictionary<string, Dictionary<IPodmiotKasowy, Currency>> zaleglosci = new Dictionary<string, Dictionary<IPodmiotKasowy, Currency>>();

        [Context]
        public Soneta.Windykacja.Forms.WindykacjaViewInfo.Params Prms { get; set; }

        string GetTermin(Soneta.Windykacja.Forms.WindykacjaViewInfo.Termin t)
        {
            switch (t)
		    {
			    case Soneta.Windykacja.Forms.WindykacjaViewInfo.Termin.Razem:
                    return "Razem";
			    case Soneta.Windykacja.Forms.WindykacjaViewInfo.Termin.Dokladnie:
                    return "Dokładnie";
			    case Soneta.Windykacja.Forms.WindykacjaViewInfo.Termin.NieMniej:
                    return "Nie mniej niż";
			    case Soneta.Windykacja.Forms.WindykacjaViewInfo.Termin.NieWiecej:
                    return "Nie więcej niż";
                default:
                    return "";
		    }
        }

		void OnContextLoad(object sender, EventArgs e)
		{
            StanNaDzien.EditValue = Prms.Aktualny;
            Termin.EditValue = GetTermin(Prms.TerminPlatnosc);
            if (Prms.TerminPlatnosc != Soneta.Windykacja.Forms.WindykacjaViewInfo.Termin.Razem)
                PrzeterminowaneDni.EditValue = Prms.TerminPlatnoscDni.ToString() + " dni";
                        
			var kasa = KasaModule.GetInstance(dc.Context.Session);
            var view = kasa.Platnosci.WgTermin.CreateView();
        	view.Condition &= new FieldCondition.Equal("Kierunek", KierunekPlatnosci.Przychod);
			view.Condition &= new FieldCondition.Equal("Rozliczana", true);
            view.Condition &= new RowCondition.Exists("RozrachunkiIdx", "Dokument", new FieldCondition.Greater("DataRozliczenia", Prms.Aktualny));
        	switch (Prms.TerminPlatnosc)
			{
				case Soneta.Windykacja.Forms.WindykacjaViewInfo.Termin.Dokladnie:
					view.Condition &= new FieldCondition.Equal("Termin", Prms.Aktualny - Prms.TerminPlatnoscDni);
					break;

				case Soneta.Windykacja.Forms.WindykacjaViewInfo.Termin.NieWiecej:
					view.Condition &= new FieldCondition.GreaterEqual("Termin", Prms.Aktualny - Prms.TerminPlatnoscDni);
					break;

				case Soneta.Windykacja.Forms.WindykacjaViewInfo.Termin.NieMniej:
					view.Condition &= new FieldCondition.LessEqual("Termin", Prms.Aktualny - Prms.TerminPlatnoscDni);
					break;
			}
			view.Sort = "Podmiot asc";
            
            foreach (Naleznosc nal in view)
            {
                string symbol = nal.DoRozliczenia.Symbol;
                if (zaleglosci.ContainsKey(symbol)){
                    if (zaleglosci[symbol].ContainsKey(nal.Podmiot))
                        zaleglosci[symbol][nal.Podmiot] += nal.DoRozliczenia;
                    else
                        zaleglosci[symbol].Add(nal.Podmiot, nal.DoRozliczenia);
                }
                else {
                    zaleglosci.Add(symbol, new Dictionary<IPodmiotKasowy, Currency>());
                    zaleglosci[symbol].Add(nal.Podmiot, nal.DoRozliczenia);
                }
            }
            List<Zaleglosc> tabela = new List<Zaleglosc>(zaleglosci.Count);
            foreach (var kvp in zaleglosci)
            {
                foreach (var kvp2 in kvp.Value)
                {
                    tabela.Add(new Zaleglosc { Waluta = kvp.Key, Podmiot = kvp2.Key, DoRozliczenia = kvp2.Value });   
                }
            }		
            Grid1.DataSource = tabela.ToArray();
		}

		void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
		{
            
		}
	</script>
</head>
<body>
	<form id="ZaleglosciKontrahetow" method="post" runat="server">
	<ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad"/>
	<cc1:ReportHeader ID="ReportHeader1" Title="Zaległości kontrahentów" runat="server" />
    <p style="font-family:Tahoma; font-size:small">Stan na dzień: <strong><ea:DataLabel runat="server" ID="StanNaDzien" /></strong></p>
    <p style="font-family:Tahoma; font-size:small">Przeterminowane: <strong><ea:DataLabel runat="server" ID="Termin"/> <ea:DataLabel runat="server" ID="PrzeterminowaneDni" /></strong></p>
	<ea:Grid ID="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" Sort="Kod" EncodeHTML="true" GroupData0="Waluta" GroupLine="Waluta: {0}" ShowSum="Never" ShowGroupSum="true" GroupSumText="Suma:">
		<Columns>
			<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp." />
			<ea:GridColumn runat="server" Width="30" Align="Left" DataMember="Podmiot.Kod" Caption="Kod" EncodeHTML="True" />
			<ea:GridColumn runat="server"            Align="Left" DataMember="Podmiot.Nazwa" Total="Info" Caption="Nazwa" EncodeHTML="True" />
			<ea:GridColumn runat="server" Width="20" Align="Right" DataMember="DoRozliczenia" Total="Sum" Caption="Suma zaległości" EncodeHTML="True" />
		</Columns>
	</ea:Grid>
	</form>
</body>
</html>


